# PUF Facilitator Runbook (v1.4.1)
**Program:** People United Foundation — Ethical AI Training Portal  
**Tracks:** Leadership • Workforce • Governance  
**Format:** Cohort-based learning with optional facilitation (privacy-first; no accounts)

> This runbook helps you deliver a high-quality cohort using the existing portal pages, downloads, and templates.

---

## 1) Cohort Overview
**Goal:** Help participants apply AI responsibly to real-world community and workforce challenges, with clear boundaries and human oversight.

**Recommended cohort sizes:**  
- Basic: up to 10  
- Standard: up to 25  
- Premium: up to 50

**Recommended cadence:**  
- 3-week sprint (best) or 6-week extended
- 60–90 minutes per week live session (optional)
- Self-paced lessons between sessions

---

## 2) Cohort Setup Checklist (7 days before)
- [ ] Confirm cohort track(s): Leadership / Workforce / Governance (or blended)
- [ ] Confirm dates, session times, and session links (Zoom/Meet)
- [ ] Share access links to the portal:
  - Courses: `/courses.html`
  - Downloads: `/downloads.html`
  - Certificates: `/certificates.html`
  - Cohorts: `/cohorts.html`
- [ ] Share the “Do Not Paste” privacy reminders (Governance Lesson 3)
- [ ] Decide how participants will submit work (email, shared drive, or in-session)
- [ ] Assign roles: Facilitator + Backup + Admin contact

---

## 3) Facilitation Principles
- **No surveillance:** do not monitor or score participants.
- **Consent-first:** participants opt into sharing; sharing is optional.
- **Human oversight:** encourage verification of outputs and sources.
- **Psychological safety:** normalize learning and iteration.
- **Practical outputs:** each week produces a tangible artifact.

---

## 4) Session Plans (3-Week Sprint)
### Week 1 — Foundations + Boundaries (60–90 minutes)
**Objectives**
- Align on what AI is/is not
- Establish safe use boundaries and “Do Not Paste” rules
- Choose a capstone goal

**Agenda**
1. Welcome + norms (10)
2. Mini-lecture: AI basics + risks (15)
3. Activity: use-case selection (15)
4. Activity: boundaries + redaction practice (15)
5. Homework overview (5)
6. Q&A (10)

**Homework (self-paced)**
- Leadership: Lessons 1–3
- Workforce: Lessons 1–3
- Governance: Lessons 1–3
- Download relevant **Course Kit** and **Checklist**

---

### Week 2 — Build & Apply (60–90 minutes)
**Objectives**
- Apply lessons to real use cases (with safeguards)
- Draft artifacts (resume pack, policy draft, leadership brief)

**Agenda**
1. Check-in + wins (10)
2. Workshop: prompt-to-output-to-verification (20)
3. Small groups: draft artifacts (30)
4. Share-outs (15)
5. Homework overview (5)

**Homework**
- Leadership: Lessons 4–7
- Workforce: Lessons 4–7
- Governance: Lessons 4–6

---

### Week 3 — Capstone + Next Steps (60–90 minutes)
**Objectives**
- Finalize capstone artifacts
- Plan next 30 days
- Certificates + celebration

**Agenda**
1. Capstone work time (35)
2. Share-outs + feedback (30)
3. Next steps: rollout plan (10)
4. Certificates instructions + close (10)

**Homework**
- Final lessons + capstone page for the track

---

## 5) Capstone Options
**Leadership capstone:** AI Use Case Plan + Board/Leadership Brief  
**Workforce capstone:** Job-Ready Portfolio Pack  
**Governance capstone:** AI Governance Mini-Policy (1–2 pages)

---

## 6) Participant Support Templates (included in this folder)
- Welcome email
- Weekly reminder email
- Completion + certificate email
- Optional sponsor thank-you note

---

## 7) Post-Cohort Impact Summary (lightweight)
Capture:
- # participants
- # completed capstones (self-reported)
- 3 participant testimonials (opt-in)
- 3 example artifacts (with permission)
- Next cohort date
- Sponsorship needs

---

**Version:** v1.4.1 • © 2026 People United Foundation
